
function a = polyarea(xv, yv, tol)

  global gxv gyv
  gxv = xv; gyv = yv;

  % find bounding box for polygon
  xmin = min(xv); xmax = max(xv); 
  ymin = min(yv); ymax = max(yv);

  % compute approximate area for polygon
  a = dblquad(@chi, xmin, xmax, ymin, ymax, tol);

  return


function f = chi(x, y)

  global gxv gyv

  % handle the case when x is a vector and y is a scalar
  % (see help inpolygon)
  if(length(y)==1)
    y = ones(size(x))*y;
  end

  f = inpolygon(x, y, gxv, gyv);

  return
